#include <iostream>
#include <cstdio>
#include <cmath>

using namespace std;

const int maxn = 1 << 17;
const double phi = (sqrt(5.0) - 1) / 2.0;

int n, pw;
int vw[maxn], pf[maxn], vf[maxn], th[maxn];


double f(double s) {
	double res = s * pw;
	for (int i = 0; i < n; i++) {
		double cur = s * vw[i];
		double need = max(0.0, th[i] - cur);
		res += need / vf[i] * pf[i];
	}
	return res;
}

int main() {
 	freopen("input.txt", "r", stdin);
	while (1) {
		scanf("%d", &n);
		if (!n) break;
		scanf("%d", &pw);
		for (int i = 0; i < n; i++) {
			scanf("%d%d%d%d", &vw[i], &pf[i], &vf[i], &th[i]);
		}
		double l = 0, r = 1e5;
		double fl = f(r - (r - l) * phi);
		double fr = f(l + (r - l) * phi);
		for (int it = 0; it < 150; it++) {
			if (fl < fr) {
				fr = fl;
				r = l + (r - l) * phi;
				fl = f(r - (r - l) * phi);
			} else {
				fl = fr;
				l = r - (r - l) * phi;
				fr = f(l + (r - l) * phi);
			}
		}
		printf("%.10lf\n", f((l + r) / 2.0));
	}
	return 0;
}